<?php

namespace App\Modules\Secretariat\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MeetingDiscussionPoint extends Model 
{

    protected $table = 'meeting_discussion_points';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('content', 'meeting_id');

    public function meeting()
    {
        return $this->belongsTo('App\Modules\Secretariat\Entities\Meeting');
    }

}